<?php
require_once 'config.php';

try {
    $db = getDB();
    $sql = file_get_contents('license_migration.sql');
    $statements = array_filter(array_map('trim', explode(';', $sql)));
    
    foreach ($statements as $statement) {
        if (!empty($statement)) {
            $db->exec($statement);
        }
    }
    
    echo "✅ License system tables created successfully!<br>";
    echo "<a href='admin/licenses.php' style='background: #2563eb; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block; margin-top: 10px;'>Go to License Management</a>";
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage();
}
