-- License System Tables

CREATE TABLE IF NOT EXISTS licenses (
    id INT AUTO_INCREMENT PRIMARY KEY,
    license_key VARCHAR(50) UNIQUE NOT NULL,
    user_id INT DEFAULT NULL,
    plan_type ENUM('trial', 'monthly', 'yearly', 'lifetime') DEFAULT 'trial',
    max_devices INT DEFAULT 1,
    expires_at DATETIME,
    status ENUM('active', 'expired', 'revoked') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_license_key (license_key),
    INDEX idx_user_id (user_id)
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS license_activations (
    id INT AUTO_INCREMENT PRIMARY KEY,
    license_key VARCHAR(50) NOT NULL,
    machine_id VARCHAR(255) NOT NULL,
    user_id INT,
    activated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_checked DATETIME,
    UNIQUE KEY unique_activation (license_key, machine_id(191)),
    INDEX idx_license_key (license_key)
) ENGINE=InnoDB;

ALTER TABLE users 
ADD COLUMN license_key VARCHAR(50) DEFAULT NULL AFTER block_reason,
ADD COLUMN license_expires_at DATETIME DEFAULT NULL AFTER license_key;
