<?php
require_once 'config.php';

try {
    // Create settings table
    $pdo->exec("CREATE TABLE IF NOT EXISTS settings (
        id INT PRIMARY KEY AUTO_INCREMENT,
        setting_key VARCHAR(100) UNIQUE NOT NULL,
        setting_value TEXT NOT NULL,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )");
    
    // Insert default settings
    $pdo->exec("INSERT INTO settings (setting_key, setting_value) VALUES
        ('app_name', 'SiteShield'),
        ('app_version', '1.0.0'),
        ('about_title', 'System-wide website blocking'),
        ('about_description', 'Protects all browsers and applications')
        ON DUPLICATE KEY UPDATE setting_key=setting_key");
    
    echo "Settings table created and default values inserted successfully!";
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
