-- INSTRUCTIONS: Import this file into phpMyAdmin or run via MySQL command line
-- Database: rsecurity_db

-- Settings table for managing app settings
CREATE TABLE IF NOT EXISTS settings (
    id INT PRIMARY KEY AUTO_INCREMENT,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT NOT NULL,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default settings
INSERT INTO settings (setting_key, setting_value) VALUES
('app_name', 'SiteShield'),
('app_version', '1.0.0'),
('about_title', 'System-wide website blocking'),
('about_description', 'Protects all browsers and applications')
ON DUPLICATE KEY UPDATE setting_key=setting_key;
