<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit(0);

require_once '../config.php';

$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['machine_id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing machine_id']);
    exit;
}

try {
    $db = getDB();
    $stmt = $db->prepare("SELECT status, block_reason FROM users WHERE machine_id = ?");
    $stmt->execute([$data['machine_id']]);
    $user = $stmt->fetch();
    
    if (!$user) {
        http_response_code(404);
        echo json_encode(['error' => 'User not found', 'status' => 'unknown']);
        exit;
    }
    
    echo json_encode([
        'success' => true,
        'status' => $user['status'],
        'is_blocked' => $user['status'] === 'blocked',
        'block_reason' => $user['block_reason']
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Server error']);
}
