<?php
session_start();
require_once '../config.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit;
}

$userId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$userId) {
    header('Location: users.php');
    exit;
}

$db = getDB();
$stmt = $db->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$userId]);
$user = $stmt->fetch();

if (!$user) {
    header('Location: users.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Details - RSecurity Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <!-- Sidebar -->
        <aside class="w-64 bg-gray-900 text-white flex flex-col">
            <div class="p-6">
                <h1 class="text-2xl font-bold text-blue-400">RSecurity</h1>
                <p class="text-sm text-gray-400">Admin Panel</p>
            </div>
            <nav class="flex-1 px-4">
                <a href="dashboard.php" class="flex items-center gap-3 px-4 py-3 text-gray-300 hover:bg-gray-800 rounded-lg mb-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                    </svg>
                    Dashboard
                </a>
                <a href="users.php" class="flex items-center gap-3 px-4 py-3 bg-blue-600 rounded-lg mb-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                    </svg>
                    Users
                </a>
            </nav>
            <div class="p-4 border-t border-gray-800">
                <a href="logout.php" class="flex items-center gap-3 px-4 py-3 text-red-400 hover:bg-gray-800 rounded-lg">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                    </svg>
                    Logout
                </a>
            </div>
        </aside>
        
        <!-- Main Content -->
        <div class="flex-1 overflow-auto">
            <header class="bg-white shadow-sm">
                <div class="px-8 py-4 flex items-center gap-4">
                    <a href="users.php" class="text-gray-600 hover:text-gray-900">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                        </svg>
                    </a>
                    <h2 class="text-2xl font-bold text-gray-800">User Details</h2>
                </div>
            </header>
            <main class="p-8">
                <div class="max-w-4xl mx-auto">
                    <!-- User Info Card -->
                    <div class="bg-white rounded-lg shadow-lg p-8 mb-6">
                        <div class="flex items-center justify-between mb-6">
                            <div class="flex items-center gap-4">
                                <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center">
                                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-2xl font-bold text-gray-900"><?= htmlspecialchars($user['username']) ?></h3>
                                    <p class="text-gray-600"><?= htmlspecialchars($user['email']) ?></p>
                                </div>
                            </div>
                            <?php
                            $statusColors = [
                                'active' => 'bg-green-100 text-green-800',
                                'blocked' => 'bg-red-100 text-red-800',
                                'pending' => 'bg-yellow-100 text-yellow-800'
                            ];
                            $color = $statusColors[$user['status']] ?? 'bg-gray-100 text-gray-800';
                            ?>
                            <span class="px-4 py-2 text-sm font-semibold rounded-full <?= $color ?>">
                                <?= ucfirst($user['status']) ?>
                            </span>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Account Information -->
                            <div>
                                <h4 class="text-lg font-semibold text-gray-900 mb-4">Account Information</h4>
                                <div class="space-y-3">
                                    <div>
                                        <label class="text-sm text-gray-500">User ID</label>
                                        <p class="text-gray-900 font-mono">#<?= $user['id'] ?></p>
                                    </div>
                                    <div>
                                        <label class="text-sm text-gray-500">Email</label>
                                        <p class="text-gray-900"><?= htmlspecialchars($user['email']) ?></p>
                                    </div>
                                    <div>
                                        <label class="text-sm text-gray-500">Username</label>
                                        <p class="text-gray-900"><?= htmlspecialchars($user['username']) ?></p>
                                    </div>
                                    <div>
                                        <label class="text-sm text-gray-500">Status</label>
                                        <p class="text-gray-900"><?= ucfirst($user['status']) ?></p>
                                    </div>
                                </div>
                            </div>

                            <!-- Machine Information -->
                            <div>
                                <h4 class="text-lg font-semibold text-gray-900 mb-4">Machine Information</h4>
                                <div class="space-y-3">
                                    <div>
                                        <label class="text-sm text-gray-500">Computer Name</label>
                                        <p class="text-gray-900"><?= htmlspecialchars($user['computer_name']) ?></p>
                                    </div>
                                    <div>
                                        <label class="text-sm text-gray-500">Windows User</label>
                                        <p class="text-gray-900"><?= htmlspecialchars($user['windows_user']) ?></p>
                                    </div>
                                    <div>
                                        <label class="text-sm text-gray-500">Machine ID</label>
                                        <p class="text-gray-900 font-mono text-xs break-all"><?= htmlspecialchars($user['machine_id']) ?></p>
                                    </div>
                                </div>
                            </div>

                            <!-- System Information -->
                            <div>
                                <h4 class="text-lg font-semibold text-gray-900 mb-4">System Information</h4>
                                <div class="space-y-3">
                                    <div>
                                        <label class="text-sm text-gray-500">Operating System</label>
                                        <p class="text-gray-900"><?= htmlspecialchars($user['os']) ?></p>
                                    </div>
                                    <div>
                                        <label class="text-sm text-gray-500">OS Version</label>
                                        <p class="text-gray-900"><?= htmlspecialchars($user['os_version']) ?></p>
                                    </div>
                                    <div>
                                        <label class="text-sm text-gray-500">App Version</label>
                                        <p class="text-gray-900"><?= htmlspecialchars($user['app_version']) ?></p>
                                    </div>
                                </div>
                            </div>

                            <!-- Activity Information -->
                            <div>
                                <h4 class="text-lg font-semibold text-gray-900 mb-4">Activity Information</h4>
                                <div class="space-y-3">
                                    <div>
                                        <label class="text-sm text-gray-500">Registered At</label>
                                        <p class="text-gray-900"><?= date('F d, Y H:i:s', strtotime($user['registered_at'])) ?></p>
                                    </div>
                                    <div>
                                        <label class="text-sm text-gray-500">Last Active</label>
                                        <p class="text-gray-900"><?= $user['last_active'] ? date('F d, Y H:i:s', strtotime($user['last_active'])) : 'Never' ?></p>
                                    </div>
                                    <div>
                                        <label class="text-sm text-gray-500">Created At</label>
                                        <p class="text-gray-900"><?= date('F d, Y H:i:s', strtotime($user['created_at'])) ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="bg-white rounded-lg shadow p-6">
                        <h4 class="text-lg font-semibold text-gray-900 mb-4">Actions</h4>
                        <div class="flex gap-4">
                            <a href="users.php" class="px-6 py-2 bg-gray-500 hover:bg-gray-600 text-white rounded-lg">
                                Back to Users
                            </a>
                            <?php if ($user['status'] === 'active'): ?>
                            <form method="POST" action="users.php" class="inline">
                                <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                                <input type="hidden" name="action" value="block">
                                <button class="px-6 py-2 bg-red-600 hover:bg-red-700 text-white rounded-lg">
                                    Block User
                                </button>
                            </form>
                            <?php else: ?>
                            <form method="POST" action="users.php" class="inline">
                                <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                                <input type="hidden" name="action" value="activate">
                                <button class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white rounded-lg">
                                    Activate User
                                </button>
                            </form>
                            <?php endif; ?>
                            <form method="POST" action="users.php" class="inline" onsubmit="return confirm('Delete this user permanently?')">
                                <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                                <input type="hidden" name="action" value="delete">
                                <button class="px-6 py-2 bg-red-600 hover:bg-red-700 text-white rounded-lg">
                                    Delete User
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>
