<?php
session_start();
require_once '../config.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit;
}

$pdo = getDB();

// Create settings table if not exists
try {
    $pdo->exec("CREATE TABLE IF NOT EXISTS settings (
        id INT PRIMARY KEY AUTO_INCREMENT,
        setting_key VARCHAR(100) UNIQUE NOT NULL,
        setting_value TEXT NOT NULL,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )");
    
    // Insert default settings if table is empty
    $count = $pdo->query("SELECT COUNT(*) FROM settings")->fetchColumn();
    if ($count == 0) {
        $pdo->exec("INSERT INTO settings (setting_key, setting_value) VALUES
            ('app_name', 'SiteShield'),
            ('app_version', '1.0.0'),
            ('about_title', 'System-wide website blocking'),
            ('about_description', 'Protects all browsers and applications'),
            ('developer_name', ''),
            ('developer_email', ''),
            ('developer_website', '')");
    } else {
        // Add missing developer fields if they don't exist
        $pdo->exec("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES
            ('developer_name', ''),
            ('developer_email', ''),
            ('developer_website', '')");
    }
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $app_name = $_POST['app_name'] ?? '';
    $app_version = $_POST['app_version'] ?? '';
    $about_title = $_POST['about_title'] ?? '';
    $about_description = $_POST['about_description'] ?? '';
    $developer_name = $_POST['developer_name'] ?? '';
    $developer_email = $_POST['developer_email'] ?? '';
    $developer_website = $_POST['developer_website'] ?? '';
    
    $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
    $stmt->execute(['app_name', $app_name, $app_name]);
    $stmt->execute(['app_version', $app_version, $app_version]);
    $stmt->execute(['about_title', $about_title, $about_title]);
    $stmt->execute(['about_description', $about_description, $about_description]);
    $stmt->execute(['developer_name', $developer_name, $developer_name]);
    $stmt->execute(['developer_email', $developer_email, $developer_email]);
    $stmt->execute(['developer_website', $developer_website, $developer_website]);
    
    $success = "Settings updated successfully!";
}

// Fetch current settings
$stmt = $pdo->query("SELECT setting_key, setting_value FROM settings");
$settings = [];
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - RSecurity Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'sidebar.php'; ?>
        
        <main class="flex-1 overflow-y-auto">
            <div class="p-8">
                <h1 class="text-3xl font-bold text-gray-800 mb-6">App Settings</h1>
                
                <?php if (isset($success)): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                    <?= htmlspecialchars($success) ?>
                </div>
                <?php endif; ?>
                
                <div class="bg-white rounded-lg shadow-md p-6">
                    <form method="POST">
                        <div class="mb-6">
                            <label class="block text-gray-700 font-semibold mb-2">App Name</label>
                            <input type="text" name="app_name" value="<?= htmlspecialchars($settings['app_name'] ?? '') ?>" 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                        </div>
                        
                        <div class="mb-6">
                            <label class="block text-gray-700 font-semibold mb-2">App Version</label>
                            <input type="text" name="app_version" value="<?= htmlspecialchars($settings['app_version'] ?? '') ?>" 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                        </div>
                        
                        <div class="mb-6">
                            <label class="block text-gray-700 font-semibold mb-2">About Title</label>
                            <input type="text" name="about_title" value="<?= htmlspecialchars($settings['about_title'] ?? '') ?>" 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                        </div>
                        
                        <div class="mb-6">
                            <label class="block text-gray-700 font-semibold mb-2">About Description</label>
                            <textarea name="about_description" rows="3" 
                                      class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required><?= htmlspecialchars($settings['about_description'] ?? '') ?></textarea>
                        </div>
                        
                        <h2 class="text-xl font-bold text-gray-800 mb-4 mt-8">Developer Information</h2>
                        
                        <div class="mb-6">
                            <label class="block text-gray-700 font-semibold mb-2">Developer Name</label>
                            <input type="text" name="developer_name" value="<?= htmlspecialchars($settings['developer_name'] ?? '') ?>" 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <div class="mb-6">
                            <label class="block text-gray-700 font-semibold mb-2">Developer Email</label>
                            <input type="email" name="developer_email" value="<?= htmlspecialchars($settings['developer_email'] ?? '') ?>" 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <div class="mb-6">
                            <label class="block text-gray-700 font-semibold mb-2">Developer Website</label>
                            <input type="url" name="developer_website" value="<?= htmlspecialchars($settings['developer_website'] ?? '') ?>" 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700">
                            Save Settings
                        </button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
